*====================================================================================
* DECLARATIONS AND CALIBRATION


*------------------------------------------------------------------------------------
* Declarations for the endogenous tech change module
*------------------------------------------------------------------------------------

variable
    xRD(a,t)                    R&D intensity by activity
    xfdRD(is,t)                 Total R&D effort
    inn(a,t)                    Number of innovations that became available in the current period
    einn(a,t)                   Expected number of innovations available next period

    yfdrd(t)                    expenditure on R&D inputs
    pfdrd(t)                    price index for R&D inputs

    lambdaEn(a,v,t)             Factor augmenting productivity change (Hicks neutral)
    LambdaEnCr(a,v,t)           path of productivity centered at zero along the balanced growth path
    frontBGP(a,t)               Auxiliary variable for calibrating growth of frontier along the Balanced Growth Path in BAU simulation
    testtime(a,t)               Numer of varieties;



parameter
   rdprof(a)            R&D profit for SAM recalibration
   ChifdRD(is,t)        Share of inputs for R&D sector

   phiRDtoes(a,t)       Size of the stepping on toes effect
   phiRD(a,t)           Elasticity of knowledge production with respect to R&D intensity

   phiFrontier(a,t)     Elasticity of R&D prod. wrt frontier

   sigmaxpvt            Elasticity of substitution between varieties

   egrowth(a,t)         Expected growth of reneues of varieties
   agrowth(a,t)         Actual growth in sectors
   fgrowth(a,t)         Expected growth at the frontier
   markup(a,t)          Markup charged by variety producers who own blueprints
   frontier(a,t)        Measure of advancement of economy-wide technological frontier
   frontier0(a)         State of frontier at time t0

   einn0(a)             The number of innovations at time t0
   xRD0(a)              R&D expentiture at time t0
   obsol(a,t)           Obsolescence rate
   eobsol(a,t)          Expected obsolescence rate
   interestRD(t)        Interest rate for R&D projects

    rhoEn               Ratio of inventions to innovation rate
    fcrgrowth(a,t)      growth of productivity along the balanced growth path
    frontCr(a,t)        path of productivity along the balanced growth path;



*------------------------------------------------------------------------------------
* Introduction of monopolistic competition - adjustment of SAM
*------------------------------------------------------------------------------------
markup(a,t)$ifEnTech=0.01;

xp.l(a,t)   = (sum(is,sam(is,a))-sum(ptx,sam(ptx,a))-sum(psb,sam(psb,a)));

rdprof(a)=0;

loop((cap,a,t0),
work=markup(a,t0)/(1+markup(a,t0))*xp.l(a,t0);

if((sam(cap,a) gt work),
rdprof(a)=work;
sam(cap,a)=sam(cap,a)-rdprof(a);
);

);

sam(entr,cap)=sam(entr,cap)-sum(a,rdprof(a));

*------------------------------------------------------------------------------------
* Introduction of monopolistic competition - adjustment in calibration of enterprises savings
*------------------------------------------------------------------------------------

savEntr.l(entr,t) = sum(inv, sam(inv,entr)) + sum(ginv, sam(ginv,entr)) - sum(a,rdprof(a));

*------------------------------------------------------------------------------------
* [Assignment of values to parameters and initialization of R&D variables]
*------------------------------------------------------------------------------------

phiRDtoes(a,t)=1.0;
frontBGP.fx(a,t)=1;

phiRDtoes(a,t)=1;
phiFrontier(a,t) = 1;

phiRDtoes("a-p_c",t)=1;
phiRDtoes("a-bph",t)=1;

*whenever we switch R&D only for selected sectors, PhiFrontier can be used to prevent explosive behaviouro of xrd in bau
phiFrontier(a,t) = 1;
phiRDtoes("a-solarP",t)=0.2;
phiRDtoes("a-windP",t)=0.2;
phiRDtoes("a-coalP",t)=0.2;
phiRDtoes("a-gasP",t)=0.2;
phiRDtoes("a-otherP",t)=0.2;
phiRDtoes("a-NuclearP",t)=0.2;
phiRDtoes("a-i_s",t)=0.2;
phiRDtoes("a-otp",t)=0.2;

phiRD(a,t)=1-phiRDtoes(a,t);

sigmaxpvt=0.3;

*!careful! obsol must be bigger than egrowth.
obsol(a,t)=0.3;
obsol(a,t)$phiRD(a,t)=0.1;
obsol("a-i_s",t)=0.3;
obsol("a-otp",t)=0.3;

einn0(a) = obsol(a,t0);
inn.l(a,t)= obsol(a,t0);
einn.l(a,t)= obsol(a,t0);

rhoEn=0.022;

fgrowth(a,t)$phiRD(a,t)=0.02;

fcrgrowth(a,t)$phiRD(a,t) = fgrowth(a,t);
fcrgrowth("a-windP",t) = 0;
fcrgrowth("a-solarP",t) = 0;

frontier0(a) = (obsol(a,t0)+ fgrowth(a,t0))/(1+fgrowth(a,t0))*1/einn0(a);
frontier(a,t)= prod(tf$((years(tf) ge years(t0)) and (years(tf) le years(t))), (1+fgrowth(a,t)))/(1+fgrowth(a,t))*frontier0(a);

frontCr(a,t) = prod(tf$((years(tf) ge years(t0)) and (years(tf) le years(t))), (1+fcrgrowth(a,t)));

egrowth(a,t)=0.08*frontier0(a)/frontier(a,t);


lambdaEn.fx(a,new,t)=frontier(a,t);
lambdaEn.fx(a,old,t)=1/(1+fgrowth(a,t));
LambdaEn.fx(a,new,t) = 1;

LambdaEnCr.fx(a,v,t) = 1;

ChifdRD(is,t) = 0;
ChifdRD(inv,t) = 1;

ChifdRD(is,t) = ChifdRD(is,t)/sum(js,ChifdRD(js,t));

pfdrd.l(t) = sum(f, ChifdRD(f,t)*pf.l(f,t)) + sum(i, ChifdRD(i,t)*pa.l(i,t)) + sum(l, ChifdRD(l,t)*wage.l(l,t));

interestRD(t) = 0.03;

xRD0(a) = markup(a,t0) * sum(fptop, xfac.l(fptop,a,new,t0) * pxfac.l(fptop,a,new,t0))  /((1+interestRD(t0))/(1+egrowth(a,t0))-(1-(1+2*rhoEn)*einn0(a))) / (pfdrd.l(t0)*frontier(a,t0)**phiFrontier(a,t0)) ;

xfdRD.l(is,t) = chifdRD(is,t)*sum(a$aact(a),xRD.l(a,t)*xRD0(a)*frontier(a,t)**phiFrontier(a,t));
yfdRD.l(t) = sum(f, xfdRD.l(f,t)*pf.l(f,t)) + sum(i, xfdRD.l(i,t)*pa.l(i,t)) + sum(l, xfdRD.l(l,t)*wage.l(l,t));

xRD.l(a,t) = 1;
pfdrd.l(t)=1;
xRD.l(a,t)$xRD0(a)=1;

tRD.fx(a,t)=0;


*====================================================================================
* MODEL EQUATIONS



*------------------------------------------------------------------------------------
* Distribution of production across new and old processes; introduction of markup
*------------------------------------------------------------------------------------

*  E-1 -- Distribution of production across new and old processes


xpEnTecheq(a,t,fptop,v)$(ts(t) and aact(a))..
*xpEnTecheq(a,t,fptop,v)$(ts(t) and aact(a) and ifEnTech)..
   xfac(fptop,a,v,t)*lambdaEnCr(a,v,t) =e= (inn(a,t)*(1+rhoEn)*testtime(a,t-1)*xp(a,t) * (px(a,t)*lambdaEnCr(a,v,t)/((1+markup(a,t))*pxfac(fptop,a,v,t)))**sigmaxpvt)$(new(v))
                        +((1-obsol(a,t)*(1+2*rhoEn))*testtime.l(a,t-1)*xp(a,t) * (px(a,t)*lambdaEnCr(a,v,t)/((1+markup(a,t))*pxfac(fptop,a,v,t)))**sigmaxpvt)$old(v) ;


*  P-4 -- Aggregate unit cost of production

pxeq(a,t)$(ts(t) and aact(a)  )..
   px(a,t) * xp(a,t) =e= sum((fptop,v), xfac(fptop,a,v,t)*(1+markup(a,t))*pxfac(fptop,a,v,t)) ;


*------------------------------------------------------------------------------------
* Link the R&D intensity and innovation rate to the sectoral revenue
*------------------------------------------------------------------------------------


* RD-1 -- Number of new processes

einneq(a,t)$(ts(t) and aact(a) )..
         einn(a,t) =e= (einn0(a)*xRD(a,t)**(phiRD(a,t)))$(phiRD(a,t))
                         +(einn0(a))$(phiRD(a,t) eq 0);


* RD-3 -- RD intensity

xRDeq(a,t)$(ts(t) and aact(a))..
xRD(a,t)**(1-phiRD(a,t)) =e= ((markup(a,t) * sum(fptop, xfac(fptop,a,"new",t) * pxfac(fptop,a,"new",t)) /((1+interestRD(t))/(1+egrowth(a,t))-(1-(1+2*rhoEn)*einn(a,t))) / (pfdrd(t)*frontBGP(a,t)*frontier(a,t)**phiFrontier(a,t)) *(einn0(a)*(1/xRD0(a))/inn.l(a,t))))$(einn.l(a,t-1) and (phiRD(a,t) ne 0))
                                 + 1$((einn.l(a,t-1) eq 0) or (phiRD(a,t) eq 0));



*------------------------------------------------------------------------------------
* Demand for R&D activity
*------------------------------------------------------------------------------------


*RD-4 Total R&D expenditure

xfdRDeq(is,t)$(ts(t))..
xfdRD(is,t) =e= chifdRD(is,t)*sum(a$aact(a),xRD(a,t)*xRD0(a)*frontBGP(a,t)*frontier(a,t)**phiFrontier(a,t));


yfdRDeq(t)$(ts(t))..
yfdRD(t) =e= sum(f, xfdRD(f,t)*pf(f,t)) + sum(i, xfdRD(i,t)*pa(i,t)) + sum(l, xfdRD(l,t)*wage(l,t));

pfdRDeq(t)$(ts(t) and sum(a,phiRD(a,t)))..
pfdRD(t) =e= yfdRD(t) / (sum(f, xfdRD(f,t)) + sum(i, xfdRD(i,t)) + sum(l, xfdRD(l,t)));


*  Y-26 -- Investment savings balance

inveq(inv,t)$ts(t)..
   yf(inv,t) =e= sum(h, savh(h,t)) + savg(t) + sum(entr, savEntr(entr,t))
              +  er(t)*savf(t) - sum(i, chiPS(i)*ps(i,t)*delst(i,t)
              +  er(t)*pwm(i,t)*(1+tImp(i,t))*mdelst(i,t))
              -  sum(adpinv$map_adpInv(inv,adpinv),yf(adpinv,t))
              +  xfdRD(inv,t)*pf(inv,t)
;


*------------------------------------------------------------------------------------
* Insurance by enterprises
*------------------------------------------------------------------------------------


*  Y-20 -- Enterprise income

entrYeq(entr,t)$ts(t)..
   entrY(entr, t) =e= sum((fp,v,a), chiFac(entr,fp,t)*xfac(fp,a,v,t)*pxfac_preTax(fp,a,v,t))
            +  sum((instp,inst)$mapinst(entr,instp), transfers(instp, inst, t))
            +  SUM(inst$mapinst(entr,inst),debtPay(inst,t))
            +  sum((fptop,v,a)$(aact(a)), markup(a,t)*xfac(fptop,a,v,t)*pxfac(fptop,a,v,t))
            -  sum(f, xfdRD(f,t)*pf(f,t)) - sum(i, xfdRD(i,t)*pa(i,t)) -  sum(l, xfdRD(l,t)*wage(l,t))
;


*====================================================================================
* DYNAMICS: INTERTEMPORAL RELATIONS


*------------------------------------------------------------------------------------
* Vertical technological change: update of productivity
*------------------------------------------------------------------------------------


LambdaEn.fx(a,old,t) = (((1-inn.l(a,t-1)*(1+2*rhoEn))*LambdaEn.l(a,old,t-1)**(sigmaxfac(fptop,a,old)-1) + (1+rhoEn)*inn.l(a,t-1)*LambdaEn.l(a,new,t-1)**(sigmaxfac("f-top",a,"old")-1))/(1-rhoEn*inn.l(a,t-1)))**(1/(sigmaxfac("f-top",a,"old")-1));
LambdaEn.fx(a,new,t) = frontier(a,t);
LambdaEnCr.fx(a,v,t)$frontCr(a,t) = LambdaEn.l(a,v,t)/frontCr(a,t);

obsol(a,t)$einn.l(a,t-1) = (1+2*rhoEn)*einn.l(a,t-1);


inn.l(a,t)=obsol(a,t);
inn.fx(a,t)$einn.l(a,t-1)=einn.l(a,t-1);


*------------------------------------------------------------------------------------
* Horizontal technological change: update of number of varieties
*------------------------------------------------------------------------------------



testtime.fx(a,t)$phiRD(a,t) = (1-rhoEn*einn.l(a,t-1))*testtime.l(a,t-1)/(1-rhoEn*einn.l(a,t0));


*------------------------------------------------------------------------------------
* Direction of technological change: update of share parameters based on
*------------------------------------------------------------------------------------

alphanew(fpnest,fppar,a,v,t-1) = alphaXfacn(fpnest,fppar,a,v,t-1);

tolerance = 0.00001;

loop((new,old),
alphanew(fpnest,fppar,a,old,t-1)$( pnest(fpnest,fppar) AND (xfac.l(fppar,a,new,t-1) gt tolerance*xfac.l(fppar,a,new,t0)) and (xfac.l(fpnest,a,new,t-1) gt tolerance*xfac.l(fpnest,a,new,t0)))
                 = (xfac.l(fpnest,a,new,t-1)*lambdaxfac.l(fpnest,a,new,t-1)/xfac.l(fpPar,a,new,t-1)) * (pxfac.l(fpnest,a,new,t-1)/(lambdaxfac.l(fpnest,a,new,t-1)*pxfac.l(fpPar,a,new,t-1)))**sigmaxfac(fppar,a,old);

);

alphaXfacn(fpnest,fppar,a,old,t)$(alphaupdt(fpnest,fppar,a) and alphaXfacn(fpnest,fppar,a,old,t-1) )=((1-obsol(a,t-1))*alphaXfacn(fpnest,fppar,a,old,t-1) + inn.l(a,t-1)*(1+rhoEn)*alphanew(fpnest,fppar,a,old,t-1))/(1-inn.l(a,t-1)*rhoEn);
alphaXfacn(fpnest,fppar,a,new,t)$(alphaupdt(fpnest,fppar,a) and alphaXfacn(fpnest,fppar,a,new,t-1) )=
                                 alphaXfacn(fpnest,fppar,a,new,t-1);


*------------------------------------------------------------------------------------
* Correction of capital accumulation
*------------------------------------------------------------------------------------


kstock.fx(cap,t)$(ts(t)) = dmgDepr.l(t)* (1-depr.l(cap,t))*kstock.l(cap,t-1)
                                        + xfd.l(inv,t-1) - xfdRD.l(inv,t-1)
                                        + PhiPcInv(inv,t) * sum(ginv, xfd.l(ginv,t-1))